IF OBJECT_ID('P_GERA_MOV_VENDAS_DOMINIO') IS NOT NULL
	BEGIN
		DROP PROCEDURE P_GERA_MOV_VENDAS_DOMINIO
	END
 
GO
  
CREATE PROCEDURE P_GERA_MOV_VENDAS_DOMINIO (@CD_FILIAL   INT = 0,
                                                    @DT_INI      DATE,
                                                    @DT_FIM      DATE,
                                                    @CD_MOV_VEND INT = 0)
AS
  BEGIN

	  SET NOCOUNT ON;  

	  SELECT *
	  INTO #CTB_EXP_MOV
	  FROM CTB_EXP_MOV
	  WHERE DT_MOV BETWEEN @DT_INI AND @DT_FIM
                   AND CD_FILIAL = @CD_FILIAL
				   AND CD_MOVIMENTO = CASE @CD_MOV_VEND WHEN 0 THEN CD_MOVIMENTO ELSE @CD_MOV_VEND END

      CREATE TABLE #MOV_VEND
        (
           ORDEM                     INT,
           [DT_MOV]                  NVARCHAR(4000),
           [CD_MOVIMENTO]            INT,
           [CODIGO_FILIAL]           INT,
		   [CODIGO_EMP_CONTAB]       INT,
           [VALOR]                   MONEY,
           [AGRUPADOR]               VARCHAR(1000),
           [COD_CONTA_DEBITO]        INT,
           [COD_CONTA_CREDITO]       INT,
           [COD_HISTORICO]           INT,
           [COMPLEMENTO_HISTORICO]   VARCHAR(8000),
           [INICIA_LOTE]             INT,
           [CENTRO_DE_CUSTO_DEBITO]  INT,
           [CENTRO_DE_CUSTO_CREDITO] INT,
           [TP_TRANSA]               VARCHAR(3),
        );

      IF( @CD_MOV_VEND = 2
           OR @CD_MOV_VEND = 4
           OR @CD_MOV_VEND = 0 )
        BEGIN
            SELECT ROW_NUMBER()
                     OVER(
                       ORDER BY DT_MOV ASC) AS Ordem,
                   DT_MOV,
                   CD_MOVIMENTO             AS cd_mov_venda,
                   CD_FILIAL                AS CODIGO_FILIAL,
				   0                        AS CODIGO_EMP_CONTAB,
                   VLR_LANC                 AS VALOR,
                   NR_DOC                   AS agrupador,
                   Max(CD_CNT_RED_DEBITO)   AS COD_CONTA_DEBITO,
                   Max(CD_CNT_RED)          AS COD_CONTA_CREDITO,
                   0                        AS COD_HISTORICO,
                   Max(HIST)                AS HISTORICO,
                   1                        AS INICIA_LOTE,
                   0                        AS CENTRO_DE_CUSTO_DEBITO,
                   0                        AS CENTRO_DE_CUSTO_CREDITO,
                   'C'                      AS TP_TRANSA
            INTO   #MOVIMENTO02
            FROM   #CTB_EXP_MOV
            WHERE  DT_MOV BETWEEN @DT_INI AND @DT_FIM
                   AND CD_FILIAL = @CD_FILIAL
                   AND CD_MOVIMENTO IN ( 2, 4 )
                   AND ( OPERACAO IN ( 'VENDAS CUSTO - CREDITO',
                                       'VENDAS PIS - CREDITO',
                                       'VENDAS COFINS - CREDITO',
                                       'VENDAS ICMS - CREDITO',
                                       'VENDAS - RECARGA CELULAR - CREDITO' )
                          OR OPERACAO_DEBITO IN ( 'VENDAS CUSTO - DEBITO',
                                                  'VENDAS PIS - DEBITO',
                                                  'VENDAS COFINS - DEBITO',
                                                  'VENDAS ICMS - DEBITO',
												  'VENDAS - RECARGA CELULAR - DEBITO'
                               ) )
                   AND VLR_LANC > 0
            GROUP  BY CD_MOVIMENTO,
                      CD_FILIAL,
                      VLR_LANC,
                      NR_DOC,
                      DT_MOV

            INSERT INTO #MOVIMENTO02
            SELECT (SELECT Max(ORDEM)
                    FROM   #MOVIMENTO02)
                   + ROW_NUMBER() OVER(ORDER BY NR_DOC, CASE WHEN OPERACAO =
                   'VENDAS - CREDITO'
                   THEN 1 ELSE 0 END DESC, CASE WHEN TP_TRANSA = 'C' THEN 1 ELSE
                   0
                   END
                   DESC)
                   AS
                   Linha,
                   DT_MOV,
                   CD_MOVIMENTO
                   AS cd_mov_venda,
                   CD_FILIAL
                   AS CODIGO_FILIAL,
				   0     AS CODIGO_EMP_CONTAB,
                   VLR_LANC
                   AS VALOR,
                   NR_DOC
                   AS agrupador,
                   CD_CNT_RED_DEBITO
                   AS COD_CONTA_DEBITO,
                   CD_CNT_RED
                   AS COD_CONTA_CREDITO,
                   0
                   AS COD_HISTORICO,
                   HIST
                   AS HISTORICO,
                   CASE
                     WHEN OPERACAO = 'VENDAS - CREDITO' THEN 1
                     ELSE 0
                   END
                   AS INICIA_LOTE,
                   0
                   AS CENTRO_DE_CUSTO_DEBITO,
                   0
                   AS CENTRO_DE_CUSTO_CREDITO,
                   TP_TRANSA
            FROM   #CTB_EXP_MOV M
            WHERE  DT_MOV BETWEEN @DT_INI AND @DT_FIM
                   AND CD_FILIAL = @CD_FILIAL
                   AND CD_MOVIMENTO IN ( 2, 4 )
                   AND ( OPERACAO NOT IN ( 'VENDAS CUSTO - CREDITO',
                                           'VENDAS PIS - CREDITO',
                                           'VENDAS COFINS - CREDITO',
                                           'VENDAS ICMS - CREDITO',
                                           'VENDAS - RECARGA CELULAR - CREDITO'
                                         )
                         AND OPERACAO_DEBITO NOT IN (
                             'VENDAS CUSTO - DEBITO', 'VENDAS PIS - DEBITO',
                             'VENDAS COFINS - DEBITO',
                             'VENDAS ICMS - DEBITO',
                             'VENDAS - RECARGA CELULAR - DEBITO' ) )
                   AND VLR_LANC > 0
            ORDER  BY NR_DOC,
                      CASE
                        WHEN OPERACAO = 'VENDAS - CREDITO' THEN 1
                        ELSE 0
                      END DESC,
                      CASE
                        WHEN TP_TRANSA = 'C' THEN 1
                        ELSE 0
                      END DESC

            INSERT INTO #MOV_VEND
            SELECT *
            FROM   #MOVIMENTO02

			DROP TABLE #MOVIMENTO02;
        END

      IF( @CD_MOV_VEND = 7
           OR @CD_MOV_VEND = 0 )
        BEGIN
            SELECT ROW_NUMBER()
                     OVER(
                       ORDER BY DT_MOV ASC) AS Ordem,
                   DT_MOV,
                   CD_MOVIMENTO             AS cd_mov_venda,
                   CD_FILIAL                AS CODIGO_FILIAL,
				   0                        AS CODIGO_EMP_CONTAB,
                   VLR_LANC                 AS VALOR,
                   NR_DOC                   AS agrupador,
                   Max(CD_CNT_RED_DEBITO)   AS COD_CONTA_DEBITO,
                   Max(CD_CNT_RED)          AS COD_CONTA_CREDITO,
                   0                        AS COD_HISTORICO,
                   Max(HIST)                AS HISTORICO,
                   1                        AS INICIA_LOTE,
                   0                        AS CENTRO_DE_CUSTO_DEBITO,
                   0                        AS CENTRO_DE_CUSTO_CREDITO,
                   'C'                      AS TP_TRANSA
            INTO   #MOVIMENTO07
            FROM   #CTB_EXP_MOV M
                   CROSS APPLY (SELECT Count(1) AS QT
                                FROM   #CTB_EXP_MOV M2
                                WHERE  M2.NR_DOC = M.NR_DOC
                                       AND M2.CD_FILIAL = M.CD_FILIAL
                                       AND M2.TP_TRANSA = 'C') TC
                   CROSS APPLY (SELECT Count(1) AS QT
                                FROM   #CTB_EXP_MOV M2
                                WHERE  M2.NR_DOC = M.NR_DOC
                                       AND M2.CD_FILIAL = M.CD_FILIAL
                                       AND M2.TP_TRANSA = 'D') TD
            WHERE  DT_MOV BETWEEN @DT_INI AND @DT_FIM
                   AND CD_FILIAL = @CD_FILIAL
                   AND CD_MOVIMENTO IN ( 07 )
                   AND VLR_LANC > 0
                   AND TC.QT = TD.QT
            GROUP  BY CD_MOVIMENTO,
                      CD_FILIAL,
                      VLR_LANC,
                      CD_MOVIMENTO,
                      NR_DOC,
                      DT_MOV

            INSERT INTO #MOVIMENTO07
            SELECT (SELECT Max(ORDEM)
                    FROM   #MOVIMENTO07)
                   + ROW_NUMBER() OVER(ORDER BY NR_DOC, CASE WHEN CD_LANC = (
                   SELECT
                   Max
                   (
                   CD_LANC)
                   FROM #CTB_EXP_MOV MOV2 WHERE MOV2.TP_TRANSA = 'C' AND
                   MOV2.NR_DOC =
                   M.NR_DOC AND
                   MOV2.DT_MOV BETWEEN @DT_INI AND @DT_FIM) THEN 1 ELSE 0 END
                   DESC
                   ,
                   CASE
                   WHEN
                   TP_TRANSA = 'C' THEN 1 ELSE 0 END DESC) AS Linha,
                   DT_MOV,
                   CD_MOVIMENTO                            AS cd_mov_venda,
                   CD_FILIAL                               AS CODIGO_FILIAL,
				   0                        AS CODIGO_EMP_CONTAB,
                   VLR_LANC                                AS VALOR,
                   NR_DOC                                  AS agrupador,
                   CD_CNT_RED_DEBITO                       AS COD_CONTA_DEBITO,
                   CD_CNT_RED                              AS COD_CONTA_CREDITO,
                   0                                       AS COD_HISTORICO,
                   HIST                                    AS HISTORICO,
                   CASE
                     WHEN CD_LANC = (SELECT Max(CD_LANC)
                                     FROM   #CTB_EXP_MOV MOV2
                                     WHERE  MOV2.TP_TRANSA = 'C'
                                            AND MOV2.NR_DOC = M.NR_DOC
                                            AND MOV2.DT_MOV BETWEEN
                                                @DT_INI AND @DT_FIM)
                   THEN 1
                     ELSE 0
                   END                                     AS INICIA_LOTE,
                   0                                       AS
                   CENTRO_DE_CUSTO_DEBITO,
                   0                                       AS
                   CENTRO_DE_CUSTO_CREDITO,
                   TP_TRANSA
            FROM   #CTB_EXP_MOV M
                   CROSS APPLY (SELECT Count(1) AS QT
                                FROM   #CTB_EXP_MOV M2
                                WHERE  M2.NR_DOC = M.NR_DOC
                                       AND M2.CD_FILIAL = M.CD_FILIAL
                                       AND M2.TP_TRANSA = 'C') TC
                   CROSS APPLY (SELECT Count(1) AS QT
                                FROM   #CTB_EXP_MOV M2
                                WHERE  M2.NR_DOC = M.NR_DOC
                                       AND M2.CD_FILIAL = M.CD_FILIAL
                                       AND M2.TP_TRANSA = 'D') TD
            WHERE  DT_MOV BETWEEN @DT_INI AND @DT_FIM
                   AND CD_FILIAL = @CD_FILIAL
                   AND CD_MOVIMENTO IN ( 07 )
                   AND VLR_LANC > 0
                   AND TC.QT <> TD.QT
            ORDER  BY NR_DOC,
                      CASE
                        WHEN CD_LANC = (SELECT Max(CD_LANC)
                                        FROM   #CTB_EXP_MOV MOV2
                                        WHERE  MOV2.TP_TRANSA = 'C'
                                               AND MOV2.NR_DOC = M.NR_DOC
                                               AND MOV2.DT_MOV BETWEEN
                                                   @DT_INI AND @DT_FIM)
                      THEN 1
                        ELSE 0
                      END DESC,
                      CASE
                        WHEN TP_TRANSA = 'C' THEN 1
                        ELSE 0
                      END DESC

            INSERT INTO #MOV_VEND
            SELECT *
            FROM   #MOVIMENTO07

			DROP TABLE #MOVIMENTO07;

        END

      IF( @CD_MOV_VEND = 8
           OR @CD_MOV_VEND = 0 )
        BEGIN
            SELECT ROW_NUMBER()
                     OVER(
                       ORDER BY DT_MOV ASC) AS Ordem,
                   DT_MOV,
                   CD_MOVIMENTO             AS cd_mov_venda,
                   CD_FILIAL                AS CODIGO_FILIAL,
				   0                        AS CODIGO_EMP_CONTAB,
                   VLR_LANC                 AS VALOR,
                   NR_DOC                   AS agrupador,
                   Max(CD_CNT_RED_DEBITO)   AS COD_CONTA_DEBITO,
                   Max(CD_CNT_RED)          AS COD_CONTA_CREDITO,
                   0                        AS COD_HISTORICO,
                   Max(HIST)                AS HISTORICO,
                   1                        AS INICIA_LOTE,
                   0                        AS CENTRO_DE_CUSTO_DEBITO,
                   0                        AS CENTRO_DE_CUSTO_CREDITO,
                   'C'                      AS TP_TRANSA
            INTO   #MOVIMENTO08
            FROM   #CTB_EXP_MOV M
                   CROSS APPLY (SELECT Count(1) AS QT
                                FROM   #CTB_EXP_MOV M2
                                WHERE  M2.NR_DOC = M.NR_DOC
                                       AND M2.CD_FILIAL = M.CD_FILIAL
                                       AND M2.TP_TRANSA = 'C') TC
                   CROSS APPLY (SELECT Count(1) AS QT
                                FROM   #CTB_EXP_MOV M2
                                WHERE  M2.NR_DOC = M.NR_DOC
                                       AND M2.CD_FILIAL = M.CD_FILIAL
                                       AND M2.TP_TRANSA = 'D') TD
            WHERE  DT_MOV BETWEEN @DT_INI AND @DT_FIM
                   AND CD_FILIAL = @CD_FILIAL
                   AND CD_MOVIMENTO IN ( 8 )
                   AND VLR_LANC > 0
                   AND TC.QT = TD.QT
            GROUP  BY CD_MOVIMENTO,
                      CD_FILIAL,
                      VLR_LANC,
                      CD_MOVIMENTO,
                      NR_DOC,
                      DT_MOV

            INSERT INTO #MOVIMENTO08
            SELECT (SELECT Max(ORDEM)
                    FROM   #MOVIMENTO08)
                   + ROW_NUMBER() OVER(ORDER BY NR_DOC, CASE WHEN TP_TRANSA =
                   'C'
                   THEN
                   1
                   ELSE 0 END
                   DESC)             AS Linha,
                   DT_MOV,
                   CD_MOVIMENTO      AS cd_mov_venda,
                   CD_FILIAL         AS CODIGO_FILIAL,
				   0                        AS CODIGO_EMP_CONTAB,
                   VLR_LANC          AS VALOR,
                   NR_DOC            AS agrupador,
                   CD_CNT_RED_DEBITO AS COD_CONTA_DEBITO,
                   CD_CNT_RED        AS COD_CONTA_CREDITO,
                   0                 AS COD_HISTORICO,
                   HIST              AS HISTORICO,
                   CASE
                     WHEN CD_LANC = (SELECT Max(CD_LANC)
                                     FROM   #CTB_EXP_MOV MOV2
                                     WHERE  MOV2.TP_TRANSA = 'C'
                                            AND MOV2.NR_DOC = M.NR_DOC
                                            AND MOV2.DT_MOV BETWEEN
                                                @DT_INI AND @DT_FIM)
                   THEN 1
                     ELSE 0
                   END               AS INICIA_LOTE,
                   0                 AS CENTRO_DE_CUSTO_DEBITO,
                   0                 AS CENTRO_DE_CUSTO_CREDITO,
                   TP_TRANSA
            FROM   #CTB_EXP_MOV M
                   CROSS APPLY (SELECT Count(1) AS QT
                                FROM   #CTB_EXP_MOV M2
                                WHERE  M2.NR_DOC = M.NR_DOC
                                       AND M2.CD_FILIAL = M.CD_FILIAL
                                       AND M2.TP_TRANSA = 'C') TC
                   CROSS APPLY (SELECT Count(1) AS QT
                                FROM   #CTB_EXP_MOV M2
                                WHERE  M2.NR_DOC = M.NR_DOC
                                       AND M2.CD_FILIAL = M.CD_FILIAL
                                       AND M2.TP_TRANSA = 'D') TD
            WHERE  DT_MOV BETWEEN @DT_INI AND @DT_FIM
                   AND CD_FILIAL = @CD_FILIAL
                   AND CD_MOVIMENTO IN ( 08 )
                   AND VLR_LANC > 0
                   AND TC.QT <> TD.QT
            ORDER  BY NR_DOC,
                      CASE
                        WHEN TP_TRANSA = 'C' THEN 1
                        ELSE 0
                      END DESC

            INSERT INTO #MOV_VEND
            SELECT *
            FROM   #MOVIMENTO08

			DROP TABLE #MOVIMENTO08;
        END

      IF( @CD_MOV_VEND = 9
           OR @CD_MOV_VEND = 0 )
        BEGIN
            INSERT INTO #MOV_VEND
            SELECT ROW_NUMBER()
                     OVER(
                       ORDER BY DT_MOV ASC) AS Ordem,
                   DT_MOV,
                   CD_MOVIMENTO             AS cd_mov_venda,
                   CD_FILIAL                AS CODIGO_FILIAL,
				   0                        AS CODIGO_EMP_CONTAB,
                   VLR_LANC                 AS VALOR,
                   NR_DOC                   AS agrupador,
                   Max(CD_CNT_RED_DEBITO)   AS COD_CONTA_DEBITO,
                   Max(CD_CNT_RED)          AS COD_CONTA_CREDITO,
                   0                        AS COD_HISTORICO,
                   Max(HIST)                AS HISTORICO,
                   1                        AS INICIA_LOTE,
                   0                        AS CENTRO_DE_CUSTO_DEBITO,
                   0                        AS CENTRO_DE_CUSTO_CREDITO,
                   'C'                      AS TP_TRANSA
            FROM   #CTB_EXP_MOV
            WHERE  DT_MOV BETWEEN @DT_INI AND @DT_FIM
                   AND CD_FILIAL = @CD_FILIAL
                   AND CD_MOVIMENTO IN ( 9 )
                   AND VLR_LANC > 0
            GROUP  BY CD_MOVIMENTO,
                      CD_FILIAL,
                      VLR_LANC,
                      NR_DOC,
                      DT_MOV
        END

      IF( @CD_MOV_VEND = 10
           OR @CD_MOV_VEND = 0 )
        BEGIN
            INSERT INTO #MOV_VEND
            SELECT ROW_NUMBER()
                     OVER(
                       ORDER BY DT_MOV ASC) AS Ordem,
                   DT_MOV,
                   CD_MOVIMENTO             AS cd_mov_venda,
                   CD_FILIAL                AS CODIGO_FILIAL,
				   0                        AS CODIGO_EMP_CONTAB,
                   VLR_LANC                 AS VALOR,
                   NR_DOC                   AS agrupador,
                   Max(CD_CNT_RED_DEBITO)   AS COD_CONTA_DEBITO,
                   Max(CD_CNT_RED)          AS COD_CONTA_CREDITO,
                   0                        AS cod_historico,
                   Max(HIST)                AS HISTORICO,
                   1                        AS INICIA_LOTE,
                   0                        AS CENTRO_DE_CUSTO_DEBITO,
                   0                        AS CENTRO_DE_CUSTO_CREDITO,
                   'C'                      AS TP_TRANSA
            FROM   #CTB_EXP_MOV
            WHERE  DT_MOV BETWEEN @DT_INI AND @DT_FIM
                   AND CD_FILIAL = @CD_FILIAL
                   AND CD_MOVIMENTO IN ( 10 )
                   AND VLR_LANC > 0
            GROUP  BY CD_MOVIMENTO,
                      CD_FILIAL,
                      VLR_LANC,
                      NR_DOC,
                      DT_MOV
        END

      IF( @CD_MOV_VEND = 11
           OR @CD_MOV_VEND = 0 )
        BEGIN
            INSERT INTO #MOV_VEND
            SELECT ROW_NUMBER()
                     OVER(
                       ORDER BY DT_MOV ASC) AS Ordem,
                   DT_MOV,
                   CD_MOVIMENTO             AS cd_mov_venda,
                   CD_FILIAL                AS CODIGO_FILIAL,
				   0                        AS CODIGO_EMP_CONTAB,
                   VLR_LANC                 AS VALOR,
                   NR_DOC                   AS agrupador,
                   Max(CD_CNT_RED_DEBITO)   AS COD_CONTA_DEBITO,
                   Max(CD_CNT_RED)          AS COD_CONTA_CREDITO,
                   0                        AS cod_historico,
                   Max(HIST)                AS HISTORICO,
                   1                        AS INICIA_LOTE,
                   0                        AS CENTRO_DE_CUSTO_DEBITO,
                   0                        AS CENTRO_DE_CUSTO_CREDITO,
                   'C'                      AS TP_TRANSA
            FROM   #CTB_EXP_MOV
            WHERE  DT_MOV BETWEEN @DT_INI AND @DT_FIM
                   AND CD_FILIAL = @CD_FILIAL
                   AND CD_MOVIMENTO IN ( 11 )
            GROUP  BY CD_MOVIMENTO,
                      CD_FILIAL,
                      VLR_LANC,
                      NR_DOC,
                      DT_MOV
        END

      IF( @CD_MOV_VEND = 12
           OR @CD_MOV_VEND = 0 )
        BEGIN
            INSERT INTO #MOV_VEND
            SELECT ROW_NUMBER()
                     OVER(
                       ORDER BY DT_MOV ASC) AS Ordem,
                   DT_MOV,
                   CD_MOVIMENTO             AS cd_mov_venda,
                   CD_FILIAL                AS CODIGO_FILIAL,
				   0                        AS CODIGO_EMP_CONTAB,
                   VLR_LANC                 AS VALOR,
                   NR_DOC                   AS agrupador,
                   Max(CD_CNT_RED_DEBITO)   AS COD_CONTA_DEBITO,
                   Max(CD_CNT_RED)          AS COD_CONTA_CREDITO,
                   0                        AS cod_historico,
                   Max(HIST)                AS HISTORICO,
                   1                        AS INICIA_LOTE,
                   0                        AS CENTRO_DE_CUSTO_DEBITO,
                   0                        AS CENTRO_DE_CUSTO_CREDITO,
                   'C'                      AS TP_TRANSA
            FROM   #CTB_EXP_MOV
            WHERE  DT_MOV BETWEEN @DT_INI AND @DT_FIM
                   AND CD_FILIAL = @CD_FILIAL
                   AND CD_MOVIMENTO IN ( 12 )
                   AND VLR_LANC > 0
            GROUP  BY CD_MOVIMENTO,
                      CD_FILIAL,
                      VLR_LANC,
                      NR_DOC,
                      NR_DOC,
                      DT_MOV
        END

      IF( @CD_MOV_VEND = 13
           OR @CD_MOV_VEND = 0 )
        BEGIN
            INSERT INTO #MOV_VEND
            SELECT ROW_NUMBER()
                     OVER(
                       ORDER BY DT_MOV ASC) AS Ordem,
                   DT_MOV,
                   CD_MOVIMENTO             AS cd_mov_venda,
                   CD_FILIAL                AS CODIGO_FILIAL,
				   0                        AS CODIGO_EMP_CONTAB,
                   VLR_LANC                 AS VALOR,
                   NR_DOC + ORIG_CONTA      AS agrupador,
                   Max(CD_CNT_RED_DEBITO)   AS COD_CONTA_DEBITO,
                   Max(CD_CNT_RED)          AS COD_CONTA_CREDITO,
                   0                        AS cod_historico,
                   Max(HIST)                AS HISTORICO,
                   1                        AS INICIA_LOTE,
                   0                        AS CENTRO_DE_CUSTO_DEBITO,
                   0                        AS CENTRO_DE_CUSTO_CREDITO,
                   'C'                      AS TP_TRANSA
            FROM   #CTB_EXP_MOV
            WHERE  DT_MOV BETWEEN @DT_INI AND @DT_FIM
                   AND CD_FILIAL = @CD_FILIAL
                   AND CD_MOVIMENTO IN ( 13 )
                   AND VLR_LANC > 0
            GROUP  BY CD_MOVIMENTO,
                      CD_FILIAL,
                      VLR_LANC,
                      NR_DOC,
                      ORIG_CONTA,
                      DT_MOV
        END

      IF( @CD_MOV_VEND = 14
           OR @CD_MOV_VEND = 0 )
        BEGIN
            INSERT INTO #MOV_VEND
            SELECT ROW_NUMBER()
                     OVER(
                       ORDER BY DT_MOV ASC) AS Ordem,
                   DT_MOV,
                   CD_MOVIMENTO             AS cd_mov_venda,
                   CD_FILIAL                AS CODIGO_FILIAL,
				   0                        AS CODIGO_EMP_CONTAB,
                   VLR_LANC                 AS VALOR,
                   NR_DOC + ORIG_CONTA      AS agrupador,
                   Max(CD_CNT_RED_DEBITO)   AS COD_CONTA_DEBITO,
                   Max(CD_CNT_RED)          AS COD_CONTA_CREDITO,
                   0                        AS cod_historico,
                   Max(HIST)                AS HISTORICO,
                   1                        AS INICIA_LOTE,
                   0                        AS CENTRO_DE_CUSTO_DEBITO,
                   0                        AS CENTRO_DE_CUSTO_CREDITO,
                   'C'                      AS TP_TRANSA
            FROM   #CTB_EXP_MOV
            WHERE  DT_MOV BETWEEN @DT_INI AND @DT_FIM
                   AND CD_FILIAL = @CD_FILIAL
                   AND CD_MOVIMENTO IN ( 14 )
                   AND VLR_LANC > 0
            GROUP  BY CD_MOVIMENTO,
                      CD_FILIAL,
                      VLR_LANC,
                      NR_DOC,
                      ORIG_CONTA,
                      DT_MOV
        END

      IF( @CD_MOV_VEND = 15
           OR @CD_MOV_VEND = 0 )
        BEGIN
            SELECT ROW_NUMBER()
                     OVER(
                       ORDER BY DT_MOV ASC)         AS Ordem,
                   DT_MOV,
                   CD_MOVIMENTO                     AS cd_mov_venda,
                   CD_FILIAL                        AS CODIGO_FILIAL,
				   0                        AS CODIGO_EMP_CONTAB,
                   VLR_LANC                         AS VALOR,
                   NR_DOC + CONVERT(VARCHAR, NR_DP) AS agrupador,
                   Max(CD_CNT_RED_DEBITO)           AS COD_CONTA_DEBITO,
                   Max(CD_CNT_RED)                  AS COD_CONTA_CREDITO,
                   0                                AS cod_historico,
                   Max(HIST)                        AS historico,
                   1                                AS INICIA_LOTE,
                   0                                AS CENTRO_DE_CUSTO_DEBITO,
                   0                                AS CENTRO_DE_CUSTO_CREDITO,
                   'C'                              AS TP_TRANSA
            INTO   #MOVIMENTO15
            FROM   #CTB_EXP_MOV C1
            WHERE  DT_MOV BETWEEN @DT_INI AND @DT_FIM
                   AND CD_FILIAL = @CD_FILIAL
                   AND CD_MOVIMENTO IN ( 15 )
                   AND VLR_LANC > 0
                   AND NR_DOC NOT LIKE '%-%'
            GROUP  BY CD_MOVIMENTO,
                      CD_FILIAL,
                      VLR_LANC,
                      CD_MOVIMENTO,
                      NR_DOC,
                      DT_MOV,
                      CONVERT(VARCHAR, NR_DP)

            INSERT INTO #MOVIMENTO15
            SELECT (SELECT Max(ORDEM)
                    FROM   #MOVIMENTO15)
                   + ROW_NUMBER() OVER(ORDER BY NR_DP, CASE WHEN (RIGHT(NR_DOC,
                   2)
                   =
                   '-1'
                   AND
                   TP_TRANSA = 'C') THEN 1 ELSE 0 END DESC, CASE WHEN TP_TRANSA
                   =
                   'C'
                   THEN 1
                   ELSE 0
                   END DESC)                        AS Linha,
                   DT_MOV,
                   CD_MOVIMENTO                     AS cd_mov_venda,
                   CD_FILIAL                        AS CODIGO_FILIAL,
				   0                        AS CODIGO_EMP_CONTAB,
                   VLR_LANC                         AS VALOR,
                   NR_DOC + CONVERT(VARCHAR, NR_DP) AS agrupador,
                   CD_CNT_RED_DEBITO                AS COD_CONTA_DEBITO,
                   CD_CNT_RED                       AS COD_CONTA_CREDITO,
                   0                                AS cod_historico,
                   HIST                             AS HISTORICO,
                   CASE
                     WHEN RIGHT(NR_DOC, 2) = '-1'
                          AND TP_TRANSA = 'C' THEN 1
                     ELSE 0
                   END                              AS INICIA_LOTE,
                   0                                AS CENTRO_DE_CUSTO_DEBITO,
                   0                                AS CENTRO_DE_CUSTO_CREDITO,
                   TP_TRANSA
            FROM   #CTB_EXP_MOV C1
                   OUTER APPLY (SELECT TOP 1 1 AS q
                                FROM   #CTB_EXP_MOV C
                                WHERE  C.CD_MOVIMENTO = C1.CD_MOVIMENTO
                                       AND C.CD_FILIAL = C1.CD_FILIAL
                                       AND C.NR_DP = C1.NR_DP
                                       AND C.CD_EMP = C1.CD_EMP
                                       AND RIGHT(C.NR_DOC, 2) = '-1') AS Q
            WHERE  DT_MOV BETWEEN @DT_INI AND @DT_FIM
                   AND CD_FILIAL = @CD_FILIAL
                   AND CD_MOVIMENTO IN ( 15 )
                   AND VLR_LANC > 0
                   AND NR_DOC LIKE '%-%'
            ORDER  BY NR_DP,
                      CASE
                        WHEN ( RIGHT(NR_DOC, 2) = '-1'
                               AND TP_TRANSA = 'C' ) THEN 1
                        ELSE 0
                      END DESC,
                      CASE
                        WHEN TP_TRANSA = 'C' THEN 1
                        ELSE 0
                      END DESC

            INSERT INTO #MOV_VEND
            SELECT *
            FROM   #MOVIMENTO15

			DROP TABLE #MOVIMENTO15;
        END

      IF( @CD_MOV_VEND = 16
           OR @CD_MOV_VEND = 0 )

        BEGIN

			  SELECT m.*
			  INTO #CTB_EXP_MOV16
			  FROM CTB_EXP_MOV m
			  INNER JOIN PRC_GRP_ECON_PRC_FILIAL GRPAUX ON GRPAUX.CD_FILIAL = @CD_FILIAL
							INNER JOIN PRC_GRP_ECON_PRC_FILIAL GRP on GRP.CD_GRP_ECON = GRPAUX.CD_GRP_ECON AND M.CD_FILIAL = GRP.CD_FILIAL
			  WHERE DT_MOV BETWEEN @DT_INI AND @DT_FIM
					   AND CD_MOVIMENTO = 16

            SELECT ROW_NUMBER()
                     OVER(
                       ORDER BY DT_MOV ASC) AS Ordem,
                   DT_MOV,
                   CD_MOVIMENTO             AS cd_mov_venda,
                   MAX(CD_FILIAL)                AS CODIGO_FILIAL,
				   0                        AS CODIGO_EMP_CONTAB,
                   VLR_LANC                 AS VALOR,
                   COD_INTERNO_DOMINIO                   AS agrupador,
                   Max(CD_CNT_RED_DEBITO)   AS COD_CONTA_DEBITO,
                   Max(CD_CNT_RED)          AS COD_CONTA_CREDITO,
                   0                        AS cod_historico,
                   Max(HIST)                AS historico,
                   1                        AS INICIA_LOTE,
                   0                        AS CENTRO_DE_CUSTO_DEBITO,
                   0                        AS CENTRO_DE_CUSTO_CREDITO,
                   'C'                      AS TP_TRANSA
            INTO   #MOVIMENTO16
            FROM   #CTB_EXP_MOV16 M
                   CROSS APPLY (SELECT Count(1) AS QT
                                FROM   #CTB_EXP_MOV16 M2
                                WHERE  M2.COD_INTERNO_DOMINIO = M.COD_INTERNO_DOMINIO
                                       AND M2.TP_TRANSA = 'C') TC
                   CROSS APPLY (SELECT Count(1) AS QT
                                FROM   #CTB_EXP_MOV16 M2
                                WHERE  M2.COD_INTERNO_DOMINIO = M.COD_INTERNO_DOMINIO
                                       AND M2.TP_TRANSA = 'D') TD
            WHERE  DT_MOV BETWEEN @DT_INI AND @DT_FIM
                   --AND CD_FILIAL = @CD_FILIAL
                   AND CD_MOVIMENTO IN ( 16 )
                   AND VLR_LANC > 0
                   AND TC.QT = TD.QT
				   AND (TC.QT = 1 and TD.QT = 1)
            GROUP  BY CD_MOVIMENTO,
                      VLR_LANC,
                      DT_MOV,
					  COD_INTERNO_DOMINIO

	

            INSERT INTO #MOVIMENTO16
            SELECT 
					(SELECT Max(ORDEM)
                    FROM   #MOVIMENTO16)
                   + 
				   ROW_NUMBER() OVER(ORDER BY /*NR_DP, NR_DOC*/COD_INTERNO_DOMINIO, CASE WHEN ORIG_CONTA =
                   'CNT BANC'
                   AND
                   TP_TRANSA = 'C' THEN 1 ELSE 0 END DESC, CASE WHEN TP_TRANSA =
                   'C'
                   THEN 1
                   ELSE 0
                   END DESC)         AS Linha,
                   DT_MOV,
                   CD_MOVIMENTO      AS cd_mov_venda,
                   CD_FILIAL         AS CODIGO_FILIAL,
				   0                        AS CODIGO_EMP_CONTAB,
                   VLR_LANC          AS VALOR,
                   COD_INTERNO_DOMINIO            AS agrupador,
                   CD_CNT_RED_DEBITO AS COD_CONTA_DEBITO,
                   CD_CNT_RED        AS COD_CONTA_CREDITO,
                   0                 AS cod_historico,
                   HIST              AS HISTORICO,
                   CASE
                     WHEN ORIG_CONTA = 'CNT BANC'
                          AND TP_TRANSA = 'C' THEN 1
                     ELSE 0
                   END               AS INICIA_LOTE,
                   0                 AS CENTRO_DE_CUSTO_DEBITO,
                   0                 AS CENTRO_DE_CUSTO_CREDITO,
                   TP_TRANSA
			--INTO #MOVIMENTO16
            FROM   #CTB_EXP_MOV16 M
                   CROSS APPLY (SELECT Count(1) AS QT
                                FROM   #CTB_EXP_MOV16 M2
                                WHERE  
										--M2.NR_DP = M.NR_DP
          --                             AND M2.NR_DOC = M.NR_DOC
          --                             AND M2.CD_FILIAL = M.CD_FILIAL
										M2.COD_INTERNO_DOMINIO = M.COD_INTERNO_DOMINIO
                                       AND M2.TP_TRANSA = 'C') TC
                   CROSS APPLY (SELECT Count(1) AS QT
                                FROM   #CTB_EXP_MOV16 M2
                                WHERE  
								--M2.NR_DP = M.NR_DP
        --                               AND M2.NR_DOC = M.NR_DOC
        --                               AND M2.CD_FILIAL = M.CD_FILIAL
											M2.COD_INTERNO_DOMINIO = M.COD_INTERNO_DOMINIO
                                       AND M2.TP_TRANSA = 'D') TD
            WHERE  DT_MOV BETWEEN @DT_INI AND @DT_FIM
                   --AND CD_FILIAL = @CD_FILIAL
                   AND CD_MOVIMENTO IN ( 16 )
                   AND VLR_LANC > 0
                   AND (TC.QT > 1 or TD.QT > 1)
            ORDER  BY 
						--NR_DP,
						--NR_DOC,
                      COD_INTERNO_DOMINIO
					  ,CASE
                        WHEN ORIG_CONTA = 'CNT BANC'
                             AND TP_TRANSA = 'C' THEN 1
                        ELSE 0
                      END DESC,
                      CASE
                        WHEN TP_TRANSA = 'C' THEN 1
                        ELSE 0
                      END DESC

            INSERT INTO #MOV_VEND
            SELECT *
            FROM   #MOVIMENTO16

			DROP TABLE #MOVIMENTO16;
        END

      IF( @CD_MOV_VEND = 18
           OR @CD_MOV_VEND = 0 )
        BEGIN
            SELECT ROW_NUMBER()
                     OVER(
                       ORDER BY DT_MOV ASC) AS Ordem,
                   DT_MOV,
                   CD_MOVIMENTO             AS cd_mov_venda,
                   CD_FILIAL                AS CODIGO_FILIAL,
				   0                        AS CODIGO_EMP_CONTAB,
                   VLR_LANC                 AS VALOR,
                   NR_DP                    AS agrupador,
                   Max(CD_CNT_RED_DEBITO)   AS COD_CONTA_DEBITO,
                   Max(CD_CNT_RED)          AS COD_CONTA_CREDITO,
                   0                        AS cod_historico,
                   Max(HIST)                AS HISTORICO,
                   1                        AS INICIA_LOTE,
                   0                        AS CENTRO_DE_CUSTO_DEBITO,
                   0                        AS CENTRO_DE_CUSTO_CREDITO,
                   'C'                      AS TP_TRANSA
            INTO   #MOVIMENTO18
            FROM   #CTB_EXP_MOV M
                   CROSS APPLY (SELECT Count(1) AS QT
                                FROM   #CTB_EXP_MOV M2
                                WHERE  M2.NR_DP = M.NR_DP
                                       AND M2.NR_DOC = M.NR_DOC
                                       AND M2.CD_FILIAL = M.CD_FILIAL
                                       AND M2.TP_TRANSA = 'C') TC
                   CROSS APPLY (SELECT Count(1) AS QT
                                FROM   #CTB_EXP_MOV M2
                                WHERE  M2.NR_DP = M.NR_DP
                                       AND M2.NR_DOC = M.NR_DOC
                                       AND M2.CD_FILIAL = M.CD_FILIAL
                                       AND M2.TP_TRANSA = 'D') TD
            WHERE  DT_MOV BETWEEN @DT_INI AND @DT_FIM
                   AND CD_FILIAL = @CD_FILIAL
                   AND CD_MOVIMENTO IN ( 18 )
                   AND VLR_LANC > 0
                   AND TC.QT = TD.QT
            GROUP  BY CD_MOVIMENTO,
                      CD_FILIAL,
                      VLR_LANC,
                      CD_MOVIMENTO,
                      NR_DP,
                      DT_MOV

            SELECT CD_LANC
            INTO   #CONTROLE18
            FROM   #CTB_EXP_MOV M
                   CROSS APPLY (SELECT Count(1) AS QT
                                FROM   #CTB_EXP_MOV M2
                                WHERE  M2.NR_DP = M.NR_DP
                                       AND M2.NR_DOC = M.NR_DOC
                                       AND M2.CD_FILIAL = M.CD_FILIAL
                                       AND M2.HIST = M.HIST
                                       AND M2.VLR_LANC = M.VLR_LANC
                                       AND M2.TP_TRANSA = 'C') TC
                   CROSS APPLY (SELECT Count(1) AS QT
                                FROM   #CTB_EXP_MOV M2
                                WHERE  M2.NR_DP = M.NR_DP
                                       AND M2.NR_DOC = M.NR_DOC
                                       AND M2.CD_FILIAL = M.CD_FILIAL
                                       AND M2.HIST = M.HIST
                                       AND M2.VLR_LANC = M.VLR_LANC
                                       AND M2.TP_TRANSA = 'D') TD
            WHERE  DT_MOV BETWEEN @DT_INI AND @DT_FIM
                   AND CD_FILIAL = @CD_FILIAL
                   AND CD_MOVIMENTO IN ( 18 )
                   AND VLR_LANC > 0
                   AND TC.QT = TD.QT
                   AND EXISTS (SELECT 1
                               FROM   #CTB_EXP_MOV M2
                               WHERE  M2.NR_DP = M.NR_DP
                                      AND M2.CD_FILIAL = M.CD_FILIAL
                                      AND M2.OPERACAO =
                                          'RECBTO DUPLICATA - CREDITO'
                               GROUP  BY M2.NR_DP,
                                         M2.CD_FILIAL
                               HAVING Count(1) > 1)

            INSERT INTO #MOVIMENTO18
            SELECT (SELECT Max(ORDEM)
                    FROM   #MOVIMENTO18)
                   + ROW_NUMBER() OVER(ORDER BY CD_MOVIMENTO) AS Ordem,
                   DT_MOV,
                   CD_MOVIMENTO                               AS cd_mov_venda,
                   CD_FILIAL                                  AS CODIGO_FILIAL,
				   0                        AS CODIGO_EMP_CONTAB,
                   VLR_LANC                                   AS VALOR,
                   NR_DP                                      AS agrupador,
                   Max(CD_CNT_RED_DEBITO)                     AS
                   COD_CONTA_DEBITO,
                   Max(CD_CNT_RED)                            AS
                   COD_CONTA_CREDITO
                   ,
                   0                                          AS
                   cod_historico,
                   HIST                                       AS HISTORICO,
                   1                                          AS INICIA_LOTE,
                   0                                          AS
                   CENTRO_DE_CUSTO_DEBITO,
                   0                                          AS
                   CENTRO_DE_CUSTO_CREDITO
                   ,
                   'C'                                        AS TP_TRANSA
            FROM   #CTB_EXP_MOV M
                   CROSS APPLY (SELECT Count(1) AS QT
                                FROM   #CTB_EXP_MOV M2
                                WHERE  M2.NR_DP = M.NR_DP
                                       AND M2.NR_DOC = M.NR_DOC
                                       AND M2.CD_FILIAL = M.CD_FILIAL
                                       AND M2.HIST = M.HIST
                                       AND M2.VLR_LANC = M.VLR_LANC
                                       AND M2.TP_TRANSA = 'C') TC
                   CROSS APPLY (SELECT Count(1) AS QT
                                FROM   #CTB_EXP_MOV M2
                                WHERE  M2.NR_DP = M.NR_DP
                                       AND M2.NR_DOC = M.NR_DOC
                                       AND M2.CD_FILIAL = M.CD_FILIAL
                                       AND M2.HIST = M.HIST
                                       AND M2.VLR_LANC = M.VLR_LANC
                                       AND M2.TP_TRANSA = 'D') TD
            WHERE  DT_MOV BETWEEN @DT_INI AND @DT_FIM
                   AND CD_FILIAL = @CD_FILIAL
                   AND CD_MOVIMENTO IN ( 18 )
                   AND VLR_LANC > 0
                   AND TC.QT = TD.QT
                   AND EXISTS (SELECT 1
                               FROM   #CTB_EXP_MOV M2
                               WHERE  M2.NR_DP = M.NR_DP
                                      AND M2.CD_FILIAL = M.CD_FILIAL
                                      AND M2.OPERACAO =
                                          'RECBTO DUPLICATA - CREDITO'
                               GROUP  BY M2.NR_DP,
                                         M2.CD_FILIAL
                               HAVING Count(1) > 1)
            GROUP  BY CD_MOVIMENTO,
                      CD_FILIAL,
                      VLR_LANC,
                      CD_MOVIMENTO,
                      NR_DP,
                      DT_MOV,
                      HIST

            INSERT INTO #MOVIMENTO18
            SELECT (SELECT Max(ORDEM)
                    FROM   #MOVIMENTO18)
                   + ROW_NUMBER() OVER(ORDER BY NR_DP, NR_DOC, CD_BC_LANC, CASE WHEN
                   OPERACAO_DEBITO
                   =
                   'RECEBIMENTO DUPLICATA - DEBITO' AND TP_TRANSA = 'D' THEN 1 ELSE
                   0
                   END
                   DESC,
                   CASE
                   WHEN TP_TRANSA = 'D' THEN 1 ELSE 0 END DESC) AS Linha,
                   DT_MOV,
                   CD_MOVIMENTO                                 AS cd_mov_venda,
                   CD_FILIAL                                    AS CODIGO_FILIAL
                   ,
				   0                        AS CODIGO_EMP_CONTAB,
                   VLR_LANC
                   AS VALOR,
                   NR_DP                                        AS agrupador,
                   CD_CNT_RED_DEBITO                            AS
                   COD_CONTA_DEBITO,
                   CD_CNT_RED                                   AS
                   COD_CONTA_CREDITO,
                   0                                            AS cod_historico
                   ,
                   HIST
                   AS HISTORICO,
                   CASE
                     WHEN OPERACAO_DEBITO = 'RECEBIMENTO DUPLICATA - DEBITO'
                          AND TP_TRANSA = 'D' THEN 1
                     ELSE 0
                   END                                          AS INICIA_LOTE,
                   0                                            AS
                   CENTRO_DE_CUSTO_DEBITO,
                   0                                            AS
                   CENTRO_DE_CUSTO_CREDITO,
                   TP_TRANSA
            FROM   #CTB_EXP_MOV M
                   CROSS APPLY (SELECT Count(1) AS QT
                                FROM   #CTB_EXP_MOV M2
                                WHERE  M2.NR_DP = M.NR_DP
                                       AND M2.NR_DOC = M.NR_DOC
                                       AND M2.CD_FILIAL = M.CD_FILIAL
                                       AND M2.TP_TRANSA = 'C') TC
                   CROSS APPLY (SELECT Count(1) AS QT
                                FROM   #CTB_EXP_MOV M2
                                WHERE  M2.NR_DP = M.NR_DP
                                       AND M2.NR_DOC = M.NR_DOC
                                       AND M2.CD_FILIAL = M.CD_FILIAL
                                       AND M2.TP_TRANSA = 'D') TD
            WHERE  DT_MOV BETWEEN @DT_INI AND @DT_FIM
                   AND CD_FILIAL = @CD_FILIAL
                   AND CD_MOVIMENTO IN ( 18 )
                   AND VLR_LANC > 0
                   AND TC.QT <> TD.QT
                   AND M.CD_LANC NOT IN (SELECT DISTINCT CD_LANC
                                         FROM   #CONTROLE18)
            ORDER  BY NR_DP,
					  NR_DOC,
                      CD_BC_LANC,
                      CASE
                        WHEN OPERACAO_DEBITO = 'RECEBIMENTO DUPLICATA - DEBITO'
                             AND TP_TRANSA = 'D' THEN 1
                        ELSE 0
                      END DESC,
                      CASE
                        WHEN TP_TRANSA = 'D' THEN 1
                        ELSE 0
                      END DESC

            INSERT INTO #MOV_VEND
            SELECT *
            FROM   #MOVIMENTO18

			DROP TABLE #MOVIMENTO18;
			DROP TABLE #CONTROLE18;
        END

      IF( @CD_MOV_VEND = 20
           OR @CD_MOV_VEND = 0 )
        BEGIN
            INSERT INTO #MOV_VEND
            SELECT ROW_NUMBER()
                     OVER(
                       ORDER BY DT_MOV ASC) AS Ordem,
                   DT_MOV,
                   CD_MOVIMENTO             AS cd_mov_venda,
                   CD_FILIAL                AS CODIGO_FILIAL,
				   0                        AS CODIGO_EMP_CONTAB,
                   VLR_LANC                 AS VALOR,
                   CD_BC_LANC               AS agrupador,
                   Max(CD_CNT_RED_DEBITO)   AS COD_CONTA_DEBITO,
                   Max(CD_CNT_RED)          AS COD_CONTA_CREDITO,
                   0                        AS cod_historico,
                   Max(HIST)                AS HISTORICO,
                   1                        AS INICIA_LOTE,
                   0                        AS CENTRO_DE_CUSTO_DEBITO,
                   0                        AS CENTRO_DE_CUSTO_CREDITO,
                   'C'                      AS TP_TRANSA
            FROM   #CTB_EXP_MOV
            WHERE  DT_MOV BETWEEN @DT_INI AND @DT_FIM
                   AND CD_FILIAL = @CD_FILIAL
                   AND CD_MOVIMENTO IN ( 20 )
                   AND VLR_LANC > 0
            GROUP  BY CD_MOVIMENTO,
                      CD_FILIAL,
                      VLR_LANC,
                      CD_MOVIMENTO,
                      CD_BC_LANC,
                      DT_MOV
        END

      IF( @CD_MOV_VEND = 21
           OR @CD_MOV_VEND = 0 )
        BEGIN
            INSERT INTO #MOV_VEND
            SELECT ROW_NUMBER()
                     OVER(
                       ORDER BY DT_MOV ASC) AS Ordem,
                   DT_MOV,
                   CD_MOVIMENTO             AS cd_mov_venda,
                   CD_FILIAL                AS CODIGO_FILIAL,
				   0                        AS CODIGO_EMP_CONTAB,
                   VLR_LANC                 AS VALOR,
                   CD_BC_LANC               AS agrupador,
                   Max(CD_CNT_RED_DEBITO)   AS COD_CONTA_DEBITO,
                   Max(CD_CNT_RED)          AS COD_CONTA_CREDITO,
                   0                        AS COD_HISTORICO,
                   Max(HIST)                AS HISTORICO,
                   1                        AS INICIA_LOTE,
                   0                        AS CENTRO_DE_CUSTO_DEBITO,
                   0                        AS CENTRO_DE_CUSTO_CREDITO,
                   'C'                      AS TP_TRANSA
            FROM   #CTB_EXP_MOV
            WHERE  DT_MOV BETWEEN @DT_INI AND @DT_FIM
                   AND CD_FILIAL = @CD_FILIAL
                   AND CD_MOVIMENTO IN ( 21 )
                   AND VLR_LANC > 0
            GROUP  BY CD_MOVIMENTO,
                      CD_FILIAL,
                      VLR_LANC,
                      CD_BC_LANC,
                      DT_MOV
        END

      IF( @CD_MOV_VEND = 22
           OR @CD_MOV_VEND = 0 )
        BEGIN
            INSERT INTO #MOV_VEND
            SELECT ROW_NUMBER()
                     OVER(
                       ORDER BY DT_MOV ASC) AS Ordem,
                   DT_MOV,
                   CD_MOVIMENTO             AS cd_mov_venda,
                   CD_FILIAL                AS CODIGO_FILIAL,
				   0                        AS CODIGO_EMP_CONTAB,
                   VLR_LANC                 AS VALOR,
                   NR_DOC                   AS agrupador,
                   Max(CD_CNT_RED_DEBITO)   AS COD_CONTA_DEBITO,
                   Max(CD_CNT_RED)          AS COD_CONTA_CREDITO,
                   0                        AS COD_HISTORICO,
                   Max(HIST)                AS HISTORICO,
                   1                        AS INICIA_LOTE,
                   0                        AS CENTRO_DE_CUSTO_DEBITO,
                   0                        AS CENTRO_DE_CUSTO_CREDITO,
                   'C'                      AS TP_TRANSA
            FROM   #CTB_EXP_MOV
            WHERE  DT_MOV BETWEEN @DT_INI AND @DT_FIM
                   AND CD_FILIAL = @CD_FILIAL
                   AND CD_MOVIMENTO IN ( 22 )
                   AND VLR_LANC > 0
            GROUP  BY CD_MOVIMENTO,
                      CD_FILIAL,
                      VLR_LANC,
                      NR_DOC,
                      DT_MOV
        END

      IF( @CD_MOV_VEND = 23
           OR @CD_MOV_VEND = 0 )
        BEGIN
            INSERT INTO #MOV_VEND
            SELECT ROW_NUMBER()
                     OVER(
                       ORDER BY DT_MOV ASC) AS Ordem,
                   DT_MOV,
                   CD_MOVIMENTO             AS cd_mov_venda,
                   CD_FILIAL                AS CODIGO_FILIAL,
				   0                        AS CODIGO_EMP_CONTAB,
                   VLR_LANC                 AS VALOR,
                   CD_BC_LANC               AS agrupador,
                   Max(CD_CNT_RED_DEBITO)   AS COD_CONTA_DEBITO,
                   Max(CD_CNT_RED)          AS COD_CONTA_CREDITO,
                   0                        AS COD_HISTORICO,
                   Max(HIST)                AS HISTORICO,
                   1                        AS INICIA_LOTE,
                   0                        AS CENTRO_DE_CUSTO_DEBITO,
                   0                        AS CENTRO_DE_CUSTO_CREDITO,
                   'C'                      AS TP_TRANSA
            FROM   #CTB_EXP_MOV
            WHERE  DT_MOV BETWEEN @DT_INI AND @DT_FIM
                   AND CD_FILIAL = @CD_FILIAL
                   AND CD_MOVIMENTO IN ( 23 )
                   AND VLR_LANC > 0
            GROUP  BY CD_MOVIMENTO,
                      CD_FILIAL,
                      VLR_LANC,
                      CD_BC_LANC,
                      DT_MOV
        END

      IF( @CD_MOV_VEND = 24
           OR @CD_MOV_VEND = 0 )
        BEGIN
            INSERT INTO #MOV_VEND
            SELECT ROW_NUMBER()
                     OVER(
                       ORDER BY DT_MOV ASC) AS Ordem,
                   DT_MOV,
                   CD_MOVIMENTO             AS cd_mov_venda,
                   CD_FILIAL                AS CODIGO_FILIAL,
				   0                        AS CODIGO_EMP_CONTAB,
                   VLR_LANC                 AS VALOR,
                   NR_DOC                   AS agrupador,
                   Max(CD_CNT_RED_DEBITO)   AS COD_CONTA_DEBITO,
                   Max(CD_CNT_RED)          AS COD_CONTA_CREDITO,
                   0                        AS COD_HISTORICO,
                   Max(HIST)                AS HISTORICO,
                   1                        AS INICIA_LOTE,
                   0                        AS CENTRO_DE_CUSTO_DEBITO,
                   0                        AS CENTRO_DE_CUSTO_CREDITO,
                   'C'                      AS TP_TRANSA
            FROM   #CTB_EXP_MOV
            WHERE  DT_MOV BETWEEN @DT_INI AND @DT_FIM
                   AND CD_FILIAL = @CD_FILIAL
                   AND CD_MOVIMENTO IN ( 24 )
                   AND VLR_LANC > 0
            GROUP  BY CD_MOVIMENTO,
                      CD_FILIAL,
                      VLR_LANC,
                      NR_DOC,
                      DT_MOV
        END

      IF( @CD_MOV_VEND = 25
           OR @CD_MOV_VEND = 0 )
        BEGIN
            INSERT INTO #MOV_VEND
            SELECT ROW_NUMBER()
                     OVER(
                       ORDER BY DT_MOV ASC) AS Ordem,
                   DT_MOV,
                   CD_MOVIMENTO             AS cd_mov_venda,
                   CD_FILIAL                AS CODIGO_FILIAL,
				   0                        AS CODIGO_EMP_CONTAB,
                   VLR_LANC                 AS VALOR,
                   NR_DOC                   AS agrupador,
                   Max(CD_CNT_RED_DEBITO)   AS COD_CONTA_DEBITO,
                   Max(CD_CNT_RED)          AS COD_CONTA_CREDITO,
                   0                        AS COD_HISTORICO,
                   Max(HIST)                AS HISTORICO,
                   1                        AS INICIA_LOTE,
                   0                        AS CENTRO_DE_CUSTO_DEBITO,
                   0                        AS CENTRO_DE_CUSTO_CREDITO,
                   'C'                      AS TP_TRANSA
            FROM   #CTB_EXP_MOV
            WHERE  DT_MOV BETWEEN @DT_INI AND @DT_FIM
                   AND CD_FILIAL = @CD_FILIAL
                   AND CD_MOVIMENTO IN ( 25 )
                   AND VLR_LANC > 0
            GROUP  BY CD_MOVIMENTO,
                      CD_FILIAL,
                      VLR_LANC,
                      NR_DOC,
                      DT_MOV
        END

      IF( @CD_MOV_VEND = 26
           OR @CD_MOV_VEND = 0 )
        BEGIN
            INSERT INTO #MOV_VEND
            SELECT ROW_NUMBER()
                     OVER(
                       ORDER BY DT_MOV ASC) AS Ordem,
                   DT_MOV,
                   CD_MOVIMENTO             AS cd_mov_venda,
                   CD_FILIAL                AS CODIGO_FILIAL,
				   0                        AS CODIGO_EMP_CONTAB,
                   VLR_LANC                 AS VALOR,
                   NR_DOC                   AS agrupador,
                   Max(CD_CNT_RED_DEBITO)   AS COD_CONTA_DEBITO,
                   Max(CD_CNT_RED)          AS COD_CONTA_CREDITO,
                   0                        AS COD_HISTORICO,
                   Max(HIST)                AS HISTORICO,
                   1                        AS INICIA_LOTE,
                   0                        AS CENTRO_DE_CUSTO_DEBITO,
                   0                        AS CENTRO_DE_CUSTO_CREDITO,
                   'C'                      AS TP_TRANSA
            FROM   #CTB_EXP_MOV
            WHERE  DT_MOV BETWEEN @DT_INI AND @DT_FIM
                   AND CD_FILIAL = @CD_FILIAL
                   AND CD_MOVIMENTO IN ( 26 )
                   AND VLR_LANC > 0
            GROUP  BY CD_MOVIMENTO,
                      CD_FILIAL,
                      VLR_LANC,
                      NR_DOC,
                      DT_MOV
        END

      IF( @CD_MOV_VEND = 27
           OR @CD_MOV_VEND = 0 )
        BEGIN
            INSERT INTO #MOV_VEND
            SELECT ROW_NUMBER()
                     OVER(
                       ORDER BY DT_MOV ASC) AS Ordem,
                   DT_MOV,
                   CD_MOVIMENTO             AS cd_mov_venda,
                   CD_FILIAL                AS CODIGO_FILIAL,
				   0                        AS CODIGO_EMP_CONTAB,
                   VLR_LANC                 AS VALOR,
                   NR_DOC                   AS agrupador,
                   Max(CD_CNT_RED_DEBITO)   AS COD_CONTA_DEBITO,
                   Max(CD_CNT_RED)          AS COD_CONTA_CREDITO,
                   0                        AS COD_HISTORICO,
                   Max(HIST)                AS HISTORICO,
                   1                        AS INICIA_LOTE,
                   0                        AS CENTRO_DE_CUSTO_DEBITO,
                   0                        AS CENTRO_DE_CUSTO_CREDITO,
                   'C'                      AS TP_TRANSA
            FROM   #CTB_EXP_MOV
            WHERE  DT_MOV BETWEEN @DT_INI AND @DT_FIM
                   AND CD_FILIAL = @CD_FILIAL
                   AND CD_MOVIMENTO IN ( 27 )
                   AND VLR_LANC > 0
            GROUP  BY CD_MOVIMENTO,
                      CD_FILIAL,
                      VLR_LANC,
                      NR_DOC,
                      DT_MOV
        END

      IF( @CD_MOV_VEND = 28
           OR @CD_MOV_VEND = 0 )
        BEGIN
            INSERT INTO #MOV_VEND
            SELECT ROW_NUMBER()
                     OVER(
                       ORDER BY DT_MOV ASC) AS Ordem,
                   DT_MOV,
                   CD_MOVIMENTO             AS cd_mov_venda,
                   CD_FILIAL                AS CODIGO_FILIAL,
				   0                        AS CODIGO_EMP_CONTAB,
                   VLR_LANC                 AS VALOR,
                   CD_BC_LANC               AS agrupador,
                   Max(CD_CNT_RED_DEBITO)   AS COD_CONTA_DEBITO,
                   Max(CD_CNT_RED)          AS COD_CONTA_CREDITO,
                   0                        AS cod_historico,
                   Max(HIST)                AS HISTORICO,
                   1                        AS INICIA_LOTE,
                   0                        AS CENTRO_DE_CUSTO_DEBITO,
                   0                        AS CENTRO_DE_CUSTO_CREDITO,
                   'C'                      AS TP_TRANSA
            FROM   #CTB_EXP_MOV
            WHERE  DT_MOV BETWEEN @DT_INI AND @DT_FIM
                   AND CD_FILIAL = @CD_FILIAL
                   AND CD_MOVIMENTO IN ( 28 )
                   AND VLR_LANC > 0
            GROUP  BY CD_MOVIMENTO,
                      CD_FILIAL,
                      VLR_LANC,
                      CD_MOVIMENTO,
                      CD_BC_LANC,
                      DT_MOV
        END


		/*Exibe resultado final*/

		DROP TABLE #CTB_EXP_MOV;

		SELECT	 CONVERT(VARCHAR, CAST(DT_MOV AS DATE), 103) AS DT_MOV
				,CASE CONVERT(VARCHAR,COD_CONTA_DEBITO) WHEN '0' THEN '' ELSE CONVERT(VARCHAR,COD_CONTA_DEBITO) END AS COD_CONTA_DEBITO
				,CASE CONVERT(VARCHAR,COD_CONTA_CREDITO) WHEN '0' THEN '' ELSE CONVERT(VARCHAR,COD_CONTA_CREDITO) END AS COD_CONTA_CREDITO
				,VALOR
				,COD_HISTORICO
				,COMPLEMENTO_HISTORICO
				,CASE CONVERT(VARCHAR,INICIA_LOTE) WHEN '0' THEN '' ELSE CONVERT(VARCHAR,INICIA_LOTE) END AS INICIA_LOTE
				,CASE WHEN ISNULL(CD_FILIAL_CONTAB,0) = 0 THEN 
					CODIGO_FILIAL
				 ELSE 
					CD_FILIAL_CONTAB
				 END AS CODIGO_FILIAL
				--,ISNULL(CD_EMPRESA_CONTABIL,'') AS CODIGO_EMP_CONTAB
				,CENTRO_DE_CUSTO_DEBITO
				,CENTRO_DE_CUSTO_CREDITO
		FROM #MOV_VEND INNER JOIN PRC_FILIAL ON
		     #MOV_VEND.CODIGO_FILIAL =  PRC_FILIAL.CD_FILIAL
		ORDER BY CD_MOVIMENTO, ORDEM

		DROP TABLE #MOV_VEND;

		/*Fim exibição resultado final*/

  END 